/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.index.core.filter;

import com.aptana.core.IFilter;
import com.aptana.core.IMap;
import com.aptana.core.io.efs.EFSUtils;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.index.core.IndexPlugin;
import com.aptana.index.core.filter.Messages;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexFilterManager {
    private static final String ITEM_DELIMITER = "\u0000";
    private static IndexFilterManager INSTANCE;
    private Set<IFileStore> _filteredItems = this.loadFilteredItems();

    public static synchronized IndexFilterManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new IndexFilterManager();
        }
        return INSTANCE;
    }

    private IndexFilterManager() {
    }

    public void addFilterItem(IFileStore item) {
        if (item == null) {
            return;
        }
        if (!this.isFilteredItem(item)) {
            HashSet<IFileStore> toRemove = new HashSet<IFileStore>(this._filteredItems.size());
            for (IFileStore candidate : this._filteredItems) {
                if (!item.isParentOf(candidate)) continue;
                toRemove.add(candidate);
            }
            this._filteredItems.removeAll(toRemove);
            this._filteredItems.add(item);
        }
    }

    public void commitFilteredItems() {
        List uris = CollectionsUtil.map(this._filteredItems, (IMap)new IMap<IFileStore, String>(){

            public String map(IFileStore item) {
                URI uri = item.toURI();
                return uri.toString();
            }
        });
        String value = StringUtil.join((String)ITEM_DELIMITER, (Collection)uris);
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.aptana.index.core");
        prefs.put("FILTERED_INDEX_URIS", value);
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        Collection nonOverlapping = CollectionsUtil.getNonOverlapping(this.loadFilteredItems(), this._filteredItems);
        HashSet<IProject> projects = new HashSet<IProject>(nonOverlapping.size());
        for (IFileStore f : nonOverlapping) {
            IResource resource = (IResource)f.getAdapter(IResource.class);
            if (resource == null) continue;
            projects.add(resource.getProject());
        }
        for (final IProject p : projects) {
            Job job = new Job(MessageFormat.format(Messages.IndexFilterManager_Rebuilding_0, p.getName())){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        p.build(6, monitor);
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    protected Set<IFileStore> applyFilter(Set<IFileStore> fileStores) {
        if (CollectionsUtil.isEmpty(this._filteredItems) || fileStores == null) {
            return fileStores;
        }
        final IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        CollectionsUtil.filterInPlace(fileStores, (IFilter)new IFilter<IFileStore>(){

            public boolean include(IFileStore item) {
                IContainer[] iContainerArray = workspaceRoot.findContainersForLocationURI(item.toURI());
                int n = iContainerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IContainer container = iContainerArray[n2];
                    IFileStore workspaceFileStore = EFSUtils.getFileStore((IResource)container);
                    if (IndexFilterManager.this.isFilteredItem(workspaceFileStore)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        });
        return fileStores;
    }

    public Set<IFileStore> getFilteredItems() {
        return CollectionsUtil.getSetValue(this._filteredItems);
    }

    public boolean isFilteredItem(IFileStore item) {
        if (item != null) {
            for (IFileStore candidate : this.getFilteredItems()) {
                if (!candidate.equals(item) && !candidate.isParentOf(item)) continue;
                return true;
            }
        }
        return false;
    }

    private Set<IFileStore> loadFilteredItems() {
        String uris = Platform.getPreferencesService().getString("com.aptana.index.core", "FILTERED_INDEX_URIS", null, null);
        if (StringUtil.isEmpty((String)uris)) {
            return new HashSet<IFileStore>(0);
        }
        String[] urisSplit = uris.split(ITEM_DELIMITER);
        HashSet<IFileStore> filteredItems = new HashSet<IFileStore>(urisSplit.length);
        String[] stringArray = urisSplit;
        int n = urisSplit.length;
        int n2 = 0;
        while (n2 < n) {
            String uriString = stringArray[n2];
            try {
                URI uri = new URI(uriString);
                IFileStore item = EFS.getStore((URI)uri);
                if (item.fetchInfo().exists()) {
                    filteredItems.add(item);
                }
            }
            catch (URISyntaxException e) {
                IdeLog.logError((Plugin)IndexPlugin.getDefault(), (String)e.getMessage(), (Throwable)e);
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)IndexPlugin.getDefault(), (Throwable)e);
            }
            ++n2;
        }
        return filteredItems;
    }

    public void removeFilterItem(IFileStore item) {
        if (item != null && this._filteredItems != null) {
            this._filteredItems.remove(item);
        }
    }
}

